/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteImportCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-import myImport1", "add-import myImport2", "delete-import myImport1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        VdbImport[] imports = vdbs[0].getImports(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)imports.length);
        Assert.assertEquals((Object)"myImport2", (Object)imports[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myImport1");
        candidates.add("myImport2");
        this.setup("commandFiles", "addVDBImports.cmd");
        this.assertTabCompletion("delete-import myIm", candidates);
        candidates.add("MyImport3");
        this.assertTabCompletion("delete-import ", candidates);
    }
}

