/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteTranslatorCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-translator myTranslator1 tType", "add-translator myTranslator2 tType", "delete-translator myTranslator1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Translator[] translators = vdbs[0].getTranslators(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)translators.length);
        Assert.assertEquals((Object)"myTranslator2", (Object)translators[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myTranslator1");
        candidates.add("myTranslator2");
        this.setup("commandFiles", "addTranslators.cmd");
        this.assertTabCompletion("delete-translator myT", candidates);
        candidates.add("MyTranslator3");
        this.assertTabCompletion("delete-translator ", candidates);
    }
}

