/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetVdbPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb testVdb vdbPath", "cd testVdb", "set-property version 3", "unset-property version"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb", (Object)vdbs[0].getName(this.getTransaction()));
        Assert.assertEquals((long)1L, (long)vdbs[0].getVersion(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addVDBs.cmd");
        String[] commands = new String[]{"cd myVDB1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("version");
        this.assertTabCompletion("unset-property Ver", candidates);
        this.assertTabCompletion("unset-property ver", candidates);
    }
}

