/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdb;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public class UploadModelCommandTest
extends AbstractCommandTest {
    private static final File UPLOAD_MODEL = UploadModelCommandTest.getResourceFile(UploadModelCommandTest.class, (String)"PartsOracle.ddl");

    @Test
    public void shouldUploadPartsOraclePhysical() throws Exception {
        String[] commands = new String[]{"workspace", "create-vdb testVdb vdbPath", "cd testVdb", "upload-model myModel PHYSICAL " + UPLOAD_MODEL.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb", (Object)vdbs[0].getName(this.getTransaction()));
        Assert.assertEquals((long)1L, (long)vdbs[0].getModels(this.getTransaction(), new String[0]).length);
        Assert.assertEquals((Object)"myModel", (Object)vdbs[0].getModels(this.getTransaction(), new String[0])[0].getName(this.getTransaction()));
        Assert.assertEquals((long)5L, (long)vdbs[0].getModels(this.getTransaction(), new String[0])[0].getTables(this.getTransaction(), new String[0]).length);
    }
}

