/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.vdbimport;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetVdbImportPropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-import myImport", "cd myImport", "set-property version 3", "unset-property version"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        VdbImport[] imports = vdbs[0].getImports(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)imports.length);
        Assert.assertEquals((Object)"myImport", (Object)imports[0].getName(this.getTransaction()));
        Assert.assertEquals((long)1L, (long)imports[0].getVersion(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addVDBImports.cmd");
        String[] commands = new String[]{"cd myImport1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("version");
        this.assertTabCompletion("unset-property VE", candidates);
        this.assertTabCompletion("unset-property Ve", candidates);
    }
}

