/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.view;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.View;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteColumnCommandTest
extends AbstractCommandTest {
    @Test
    public void testDelete1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-view myView", "cd myView", "add-column myColumn1", "add-column myColumn2", "delete-column myColumn1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        View[] views = models[0].getViews(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)views.length);
        Assert.assertEquals((Object)"myView", (Object)views[0].getName(this.getTransaction()));
        Column[] columns = views[0].getColumns(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)columns.length);
        Assert.assertEquals((Object)"myColumn2", (Object)columns[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myColumn1");
        candidates.add("myColumn2");
        this.setup("commandFiles", "addViewColumns.cmd");
        this.assertTabCompletion("delete-column myCol", candidates);
        candidates.add("MyColumn3");
        this.assertTabCompletion("delete-column ", candidates);
    }
}

