/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.virtualprocedure;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.VirtualProcedure;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UnsetVirtualProcedurePropertyCommandTest
extends AbstractCommandTest {
    @Test
    public void testUnsetProperty1() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath", "cd myVdb", "add-model myModel", "cd myModel", "add-virtual-procedure myVirtualProcedure", "cd myVirtualProcedure", "set-property name-in-source myNameInSource", "unset-property name-in-source"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)vdbs.length, (long)1L);
        Model[] models = vdbs[0].getModels(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)models.length);
        Assert.assertEquals((Object)"myModel", (Object)models[0].getName(this.getTransaction()));
        Procedure[] procs = models[0].getProcedures(this.getTransaction(), new String[0]);
        Assert.assertEquals((long)1L, (long)procs.length);
        Assert.assertEquals((Object)true, (Object)(procs[0] instanceof VirtualProcedure));
        Assert.assertEquals((Object)"myVirtualProcedure", (Object)procs[0].getName(this.getTransaction()));
        Assert.assertEquals(null, (Object)((VirtualProcedure)procs[0]).getNameInSource(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        this.setup("commandFiles", "addVirtualProcedures.cmd");
        String[] commands = new String[]{"cd myVirtualProcedure1"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        candidates.add("name-in-source");
        this.assertTabCompletion("unset-property na", candidates);
        this.assertTabCompletion("unset-property NA", candidates);
    }
}

