/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class CreateConnectionCommandTest
extends AbstractCommandTest {
    @Test
    public void shouldCreateJdbcConnection() throws Exception {
        String[] commands = new String[]{"create-connection testSource"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)connections.length);
        Assert.assertEquals((Object)"testSource", (Object)connections[0].getName(this.getTransaction()));
        Assert.assertTrue((boolean)connections[0].isJdbc(this.getTransaction()));
    }

    @Test
    public void shouldCreateNonJdbcConnection() throws Exception {
        String[] commands = new String[]{"create-connection testSource false"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] connections = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)connections.length);
        Assert.assertEquals((Object)"testSource", (Object)connections[0].getName(this.getTransaction()));
        Assert.assertFalse((boolean)connections[0].isJdbc(this.getTransaction()));
    }
}

