/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.commands.workspace.CreateSchemaCommand;
import org.komodo.relational.model.Schema;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;

public final class CreateSchemaCommandTest
extends AbstractCommandTest {
    @Test
    public void testCreateSchema1() throws Exception {
        String[] commands = new String[]{"create-schema testSchema"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Schema[] schemas = wkspMgr.findSchemas(this.getTransaction());
        Assert.assertEquals((long)1L, (long)schemas.length);
        Assert.assertEquals((Object)"testSchema", (Object)schemas[0].getName(this.getTransaction()));
    }

    @Test
    public void shouldDisplayHelp() throws Exception {
        CreateSchemaCommand command = new CreateSchemaCommand((WorkspaceStatus)this.wsStatus);
        command.setWriter(this.getOutputWriter());
        command.printHelp(5);
        String writerOutput = this.getCommandOutput();
        Assert.assertThat((String)writerOutput, (Object)(!writerOutput.contains(CreateSchemaCommand.class.getSimpleName() + ".help") ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)writerOutput, (Object)writerOutput.contains("create-schema"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFailTooManyArgs() throws Exception {
        CreateSchemaCommand command = new CreateSchemaCommand((WorkspaceStatus)this.wsStatus);
        command.setArguments(new Arguments("aName anExtraArg"));
        CommandResult result = command.execute();
        Assert.assertThat((Object)result.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((String)result.getMessage(), (Object)result.getMessage().contains("create-schema"), (Matcher)Is.is((Object)true));
    }
}

