/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class CreateVdbCommandTest
extends AbstractCommandTest {
    @Test
    public void shouldCreateVdbWithoutOptionalPath() throws Exception {
        String[] commands = new String[]{"create-vdb testVdb"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb", (Object)vdbs[0].getName(this.getTransaction()));
    }

    @Test
    public void shouldCreateVdbWithOptionalPath() throws Exception {
        String[] commands = new String[]{"create-vdb testVdb vdbPath"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb", (Object)vdbs[0].getName(this.getTransaction()));
    }

    @Test
    public void shouldCreatePartsVdbFromBatchFile() throws Exception {
        this.setup("PartsVDBScript.txt");
        CommandResult result = this.execute();
        this.assertCommandResultOk(result);
        WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = mgr.findVdbs(this.getTransaction());
        Assert.assertThat((Object)vdbs[0].getName(this.getTransaction()), (Matcher)Is.is((Object)"PartsVDB"));
        Vdb partsVdb = vdbs[0];
        Assert.assertThat((Object)partsVdb.getTranslators(this.getTransaction(), new String[0]).length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)partsVdb.getTranslators(this.getTransaction(), new String[0])[0].getName(this.getTransaction()), (Matcher)Is.is((Object)"custom_oracle"));
    }
}

