/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.model.Schema;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteSchemaCommandTest
extends AbstractCommandTest {
    @Test
    public void testDeleteSchema1() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-schema testSchema1", "create-schema testSchema2", "commit", "delete-schema testSchema1", "commit"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Schema[] schemas = wkspMgr.findSchemas(this.getTransaction());
        Assert.assertEquals((long)1L, (long)schemas.length);
        Assert.assertEquals((Object)"testSchema2", (Object)schemas[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("mySchema1");
        candidates.add("mySchema2");
        this.setup("commandFiles", "addSchemas.cmd");
        this.assertTabCompletion("delete-schema myS", candidates);
        candidates.add("MySchema3");
        this.assertTabCompletion("delete-schema ", candidates);
    }
}

