/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class DeleteVdbCommandTest
extends AbstractCommandTest {
    @Test
    public void testDeleteVdb1() throws Exception {
        String[] commands = new String[]{"set-auto-commit false", "create-vdb testVdb1 vdbPath", "create-vdb testVdb2 vdbPath", "commit", "delete-vdb testVdb1", "commit"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"testVdb2", (Object)vdbs[0].getName(this.getTransaction()));
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myVDB1");
        candidates.add("myVDB2");
        this.setup("commandFiles", "addVDBs.cmd");
        this.assertTabCompletion("delete-vdb myV", candidates);
        candidates.add("MyVDB3");
        this.assertTabCompletion("delete-vdb ", candidates);
    }
}

