/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;
import org.komodo.utils.FileUtils;

public class ExportConnectionCommandTest
extends AbstractCommandTest {
    @Before
    public void createContext() throws Exception {
        String[] commands = new String[]{"create-connection jdbcSource", "cd jdbcSource", "set-property jndiName java:/jdbcSource", "set-property driverName oracle", "set-custom-property myProp1 prop1Value", "set-custom-property myProp2 prop2Value", "workspace", "create-connection raSource false", "cd raSource", "set-property jndiName java:/raSource", "set-property className org.something.classname", "set-property driverName salesforce", "set-custom-property myProp1 prop1Value", "set-custom-property myProp2 prop2Value", "workspace"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
    }

    @Test
    public void shouldExportJdbcSourceFromConnectionContext() throws Exception {
        File exportDest = this.createExportFile();
        String[] commands = new String[]{"commit", "cd jdbcSource", "export-connection " + exportDest.getAbsolutePath()};
        this.testExportJdbcSource(exportDest, commands);
    }

    @Test
    public void shouldExportJdbcSourceFromWorkspaceContext() throws Exception {
        File exportDest = this.createExportFile();
        String[] commands = new String[]{"commit", "export-connection jdbcSource " + exportDest.getAbsolutePath()};
        this.testExportJdbcSource(exportDest, commands);
    }

    @Test
    public void shouldExportRASourceFromConnectionContext() throws Exception {
        File exportDest = this.createExportFile();
        String[] commands = new String[]{"commit", "cd raSource", "export-connection " + exportDest.getAbsolutePath()};
        this.testExportRASource(exportDest, commands);
    }

    @Test
    public void shouldExportRASourceFromWorkspaceContext() throws Exception {
        File exportDest = this.createExportFile();
        String[] commands = new String[]{"commit", "export-connection raSource " + exportDest.getAbsolutePath()};
        this.testExportRASource(exportDest, commands);
    }

    private void testExportJdbcSource(File exportDest, String[] commands) throws Exception {
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        String exportedXml = FileUtils.readSafe((File)exportDest);
        Assert.assertTrue((boolean)exportedXml.contains("<jdbc-connection name=\"jdbcSource\">"));
        Assert.assertTrue((boolean)exportedXml.contains("<jndi-name>java:/jdbcSource</jndi-name>"));
        Assert.assertTrue((boolean)exportedXml.contains("<driver-name>oracle</driver-name>"));
        Assert.assertTrue((boolean)exportedXml.contains("<property name=\"myProp1\">prop1Value</property>"));
        Assert.assertTrue((boolean)exportedXml.contains("<property name=\"myProp2\">prop2Value</property>"));
    }

    private void testExportRASource(File exportDest, String[] commands) throws Exception {
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        String exportedXml = FileUtils.readSafe((File)exportDest);
        Assert.assertTrue((boolean)exportedXml.contains("<resource-connection name=\"raSource\">"));
        Assert.assertTrue((boolean)exportedXml.contains("<jndi-name>java:/raSource</jndi-name>"));
        Assert.assertTrue((boolean)exportedXml.contains("<driver-name>salesforce</driver-name>"));
        Assert.assertTrue((boolean)exportedXml.contains("<property name=\"myProp1\">prop1Value</property>"));
        Assert.assertTrue((boolean)exportedXml.contains("<property name=\"myProp2\">prop2Value</property>"));
        Assert.assertTrue((boolean)exportedXml.contains("<driver-class>org.something.classname</driver-class>"));
    }

    private File createExportFile() {
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        return exportDest;
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("jdbcSource");
        candidates.add("raSource");
        candidates.add("mySource1");
        candidates.add("mySource2");
        candidates.add("mySource3");
        this.setup("commandFiles", "addConnections.cmd");
        this.assertTabCompletion("export-connection ", candidates);
    }
}

