/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.test.utils.TestUtilities;
import org.w3c.dom.Document;

public class ExportVdbCommandTest
extends AbstractCommandTest {
    private KomodoObject addTweetVdbExample() throws KException, Exception {
        KomodoObject kWorkspace = _repo.komodoWorkspace(this.getTransaction());
        KomodoObject tweet = TestUtilities.createTweetExampleNode((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)kWorkspace);
        Assert.assertNotNull((Object)tweet);
        return tweet;
    }

    private KomodoObject addAllElementsVdbExample() throws Exception {
        KomodoObject kWorkspace = _repo.komodoWorkspace(this.getTransaction());
        KomodoObject tweet = TestUtilities.createAllElementsExampleNode((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)kWorkspace);
        Assert.assertNotNull((Object)tweet);
        return tweet;
    }

    @Test
    public void shouldExportTweetVdbFromVdbContext() throws Exception {
        this.testExportTweetVdb(false);
    }

    @Test
    public void shouldExportTweetVdbFromWorkspaceContext() throws Exception {
        this.testExportTweetVdb(true);
    }

    private void testExportTweetVdb(boolean exportFromWorkspaceContext) throws Exception {
        KomodoObject tweetVdb = this.addTweetVdbExample();
        File exportCmdFile = File.createTempFile("TestExportVdbCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[exportFromWorkspaceContext ? 2 : 3];
        if (exportFromWorkspaceContext) {
            commands[0] = "commit";
            commands[1] = "export-vdb " + tweetVdb.getName(this.getTransaction()) + " " + exportDest.getAbsolutePath();
        } else {
            commands[0] = "commit";
            commands[1] = "cd " + tweetVdb.getName(this.getTransaction());
            commands[2] = "export-vdb " + exportDest.getAbsolutePath();
        }
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        Document vdbDocument = TestUtilities.createDocument((InputStream)new FileInputStream(exportDest));
        Assert.assertNotNull((Object)vdbDocument);
        InputStream tweetExample = TestUtilities.tweetExample();
        Document tweetDocument = TestUtilities.createDocument((InputStream)tweetExample);
        TestUtilities.compareDocuments((Document)tweetDocument, (Document)vdbDocument);
    }

    @Test
    public void shouldExportAllElementsVdbFromVdbContext() throws Exception {
        this.testExportAllElementsVdb(false);
    }

    @Test
    public void shouldExportAllElementsVdbFromWorkspaceContext() throws Exception {
        this.testExportAllElementsVdb(true);
    }

    private void testExportAllElementsVdb(boolean exportFromWorkspaceContext) throws Exception {
        KomodoObject allElementsVdb = this.addAllElementsVdbExample();
        File exportCmdFile = File.createTempFile("TestExportVdbCommand", ".txt");
        exportCmdFile.deleteOnExit();
        File exportDest = new File(System.getProperty("java.io.tmpdir") + File.separator + "TestExportDestination.txt");
        exportDest.deleteOnExit();
        if (exportDest.exists()) {
            exportDest.delete();
        }
        String[] commands = new String[exportFromWorkspaceContext ? 2 : 3];
        if (exportFromWorkspaceContext) {
            commands[0] = "commit";
            commands[1] = "export-vdb " + allElementsVdb.getName(this.getTransaction()) + " " + exportDest.getAbsolutePath();
        } else {
            commands[0] = "commit";
            commands[1] = "cd " + allElementsVdb.getName(this.getTransaction());
            commands[2] = "export-vdb " + exportDest.getAbsolutePath();
        }
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        Assert.assertTrue((boolean)exportDest.exists());
        Document vdbDocument = TestUtilities.createDocument((InputStream)new FileInputStream(exportDest));
        Assert.assertNotNull((Object)vdbDocument);
        InputStream allElementsExample = TestUtilities.allElementsExample();
        Document allElementsDocument = TestUtilities.createDocument((InputStream)allElementsExample);
        TestUtilities.compareDocuments((Document)allElementsDocument, (Document)vdbDocument);
    }

    @Test
    public void testTabCompleter() throws Exception {
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add("myVDB1");
        candidates.add("myVDB2");
        this.setup("commandFiles", "addVDBs.cmd");
        this.assertTabCompletion("export-vdb myV", candidates);
        candidates.add("MyVDB3");
        this.assertTabCompletion("export-vdb ", candidates);
    }
}

