/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UploadConnectionCommandTest
extends AbstractCommandTest {
    private static final File UPLOAD_SOURCE = UploadConnectionCommandTest.getResourceFile(UploadConnectionCommandTest.class, (String)"dashboardDS.xml");

    @Test
    public void shouldUploadConnection() throws Exception {
        String[] commands = new String[]{"upload-connection " + UPLOAD_SOURCE.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] sources = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)sources.length);
        Assert.assertEquals((Object)"DashboardDS", (Object)sources[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotUploadConnectionIfExists() throws Exception {
        String[] commands = new String[]{"create-connection DashboardDS ", "upload-connection " + UPLOAD_SOURCE.getAbsolutePath()};
        this.execute(commands);
    }

    @Test
    public void shouldUploadConnectionIfExistsWithOverwrite() throws Exception {
        String[] commands = new String[]{"create-connection DashboardDS ", "upload-connection " + UPLOAD_SOURCE.getAbsolutePath() + " -o"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Connection[] sources = wkspMgr.findConnections(this.getTransaction());
        Assert.assertEquals((long)1L, (long)sources.length);
        Assert.assertEquals((Object)"DashboardDS", (Object)sources[0].getName(this.getTransaction()));
    }
}

