/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.workspace;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.komodo.relational.commands.AbstractCommandTest;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.api.CommandResult;
import org.komodo.spi.repository.Repository;

public final class UploadVdbCommandTest
extends AbstractCommandTest {
    private static final File UPLOAD_VDB = UploadVdbCommandTest.getResourceFile(UploadVdbCommandTest.class, (String)"AzureService-vdb.xml");

    @Test
    public void shouldUploadVdb() throws Exception {
        String[] commands = new String[]{"upload-vdb myVdb " + UPLOAD_VDB.getAbsolutePath()};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"myVdb", (Object)vdbs[0].getName(this.getTransaction()));
    }

    @Test(expected=AssertionError.class)
    public void shouldNotUploadVdbIfExists() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath ", "upload-vdb myVdb " + UPLOAD_VDB.getAbsolutePath()};
        this.execute(commands);
    }

    @Test
    public void shouldUploadVdbIfExistsWithOverwrite() throws Exception {
        String[] commands = new String[]{"create-vdb myVdb vdbPath ", "upload-vdb myVdb " + UPLOAD_VDB.getAbsolutePath() + " -o"};
        CommandResult result = this.execute(commands);
        this.assertCommandResultOk(result);
        WorkspaceManager wkspMgr = WorkspaceManager.getInstance((Repository)_repo, (Repository.UnitOfWork)this.getTransaction());
        Vdb[] vdbs = wkspMgr.findVdbs(this.getTransaction());
        Assert.assertEquals((long)1L, (long)vdbs.length);
        Assert.assertEquals((Object)"myVdb", (Object)vdbs[0].getName(this.getTransaction()));
    }
}

