/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.komodo.relational.RelationalObject;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.repository.KomodoTypeRegistry;
import org.komodo.repository.ObjectImpl;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.ui.KomodoObjectLabelProvider;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class FindCommand
extends RelationalShellCommand {
    static final String NAME = "find";
    private static final List<KomodoType> NOT_APPLICABLE_TYPES = Arrays.asList(KomodoType.UNKNOWN, KomodoType.WORKSPACE);

    public FindCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String typeName = this.requiredArgument(0, I18n.bind((String)RelationalCommandsI18n.missingTypeName, (Object[])new Object[0]));
            KomodoType queryType = this.getQueryType(typeName);
            if (queryType == null) {
                result = new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.invalidType, (Object[])new Object[]{typeName}), null);
            } else {
                String pattern = this.optionalArgument(1);
                String[] foundObjectPaths = FindCommand.query(this.getWorkspaceStatus(), queryType, null, pattern);
                this.printResults(queryType, pattern, foundObjectPaths);
                result = CommandResult.SUCCESS;
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    public boolean isValidForCurrentContext() {
        return this.getContext() instanceof RelationalObject;
    }

    private KomodoType getQueryType(String typeArg) {
        KomodoType ktype = KomodoType.getKomodoType((String)typeArg);
        return NOT_APPLICABLE_TYPES.contains(ktype) ? null : ktype;
    }

    private void printResults(KomodoType queryType, String pattern, String[] foundObjectPaths) throws Exception {
        if (foundObjectPaths.length == 0) {
            if (StringUtils.isBlank((String)pattern)) {
                this.print(5, I18n.bind((String)RelationalCommandsI18n.noObjectsFound, (Object[])new Object[]{queryType.getType()}), new Object[0]);
            } else {
                this.print(5, I18n.bind((String)RelationalCommandsI18n.noObjectsFoundForPattern, (Object[])new Object[]{queryType.getType(), pattern}), new Object[0]);
            }
        } else {
            if (StringUtils.isBlank((String)pattern)) {
                this.print(5, I18n.bind((String)RelationalCommandsI18n.typeHeader, (Object[])new Object[]{queryType.getType()}), new Object[0]);
            } else {
                this.print(5, I18n.bind((String)RelationalCommandsI18n.typeHeaderForPattern, (Object[])new Object[]{queryType.getType(), pattern}), new Object[0]);
            }
            int indent = 10;
            for (String path : foundObjectPaths) {
                this.print(10, path, new Object[0]);
            }
        }
    }

    public static String[] query(WorkspaceStatus wsStatus, KomodoType queryType, String parentPath, String pattern) throws Exception {
        String lexiconType = KomodoTypeRegistry.getInstance().getIdentifier(queryType).getLexiconType();
        Repository.UnitOfWork transaction = wsStatus.getTransaction();
        WorkspaceManager wsMgr = WorkspaceManager.getInstance((Repository)wsStatus.getCurrentContext().getRepository(), (Repository.UnitOfWork)transaction);
        String[] searchResults = wsMgr.findByType(transaction, lexiconType, parentPath, pattern, false);
        if (searchResults.length == 0) {
            return searchResults;
        }
        ObjectImpl unknownObject = new ObjectImpl(wsStatus.getCurrentContext().getRepository(), searchResults[0], 0);
        KomodoObject resolvedObject = wsStatus.resolve((KomodoObject)unknownObject);
        KomodoObjectLabelProvider labelProvider = resolvedObject == null ? wsStatus.getCurrentContextLabelProvider() : wsStatus.getObjectLabelProvider(resolvedObject);
        String[] result = new String[searchResults.length];
        int i = 0;
        for (String absolutePath : searchResults) {
            result[i] = labelProvider.getDisplayPath(transaction, absolutePath, null);
            ++i;
        }
        return result;
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        if (this.getArguments().isEmpty()) {
            boolean noLastArg = StringUtils.isBlank((String)lastArgument);
            for (KomodoType kType : KomodoType.values()) {
                if (NOT_APPLICABLE_TYPES.contains(kType) || !noLastArg && !kType.getType().toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                candidates.add(kType.getType());
            }
            Collections.sort(candidates, new Comparator<CharSequence>(){

                @Override
                public int compare(CharSequence thisType, CharSequence thatType) {
                    return thisType.toString().compareTo(thatType.toString());
                }
            });
        }
        return TabCompletionModifier.AUTO;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.findHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.findExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.findUsage, (Object[])new Object[0]), new Object[0]);
    }
}

