/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.komodo.relational.RelationalObject;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.shell.BuiltInShellCommand;
import org.komodo.shell.api.ShellCommand;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public abstract class RelationalShellCommand
extends BuiltInShellCommand {
    protected RelationalShellCommand(WorkspaceStatus wsStatus, String ... commandNames) {
        super(wsStatus, commandNames);
    }

    protected RelationalObject get() throws Exception {
        KomodoObject kobject = this.getWorkspaceStatus().getCurrentContext();
        if (kobject instanceof RelationalObject) {
            return (RelationalObject)kobject;
        }
        throw new KException(I18n.bind((String)WorkspaceCommandsI18n.invalidObjectType, (Object[])new Object[]{kobject.getAbsolutePath()}));
    }

    public String getCategory() {
        return I18n.bind((String)RelationalCommandsI18n.relationalCommandCategory, (Object[])new Object[0]);
    }

    protected ShellCommand getCommand(String commandName) throws Exception {
        return this.getWorkspaceStatus().getCommand(commandName);
    }

    protected String getPath() throws Exception {
        return this.getWorkspaceStatus().getCurrentContext().getAbsolutePath();
    }

    protected Repository getRepository() throws KException {
        return this.getWorkspaceStatus().getCurrentContext().getRepository();
    }

    protected WorkspaceManager getWorkspaceManager(Repository.UnitOfWork transaction) throws KException {
        return WorkspaceManager.getInstance((Repository)this.getRepository(), (Repository.UnitOfWork)transaction);
    }
}

