/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.model.OptionContainer;
import org.komodo.relational.model.internal.OptionContainerUtils;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class SetCustomOptionCommand
extends RelationalShellCommand {
    static final String NAME = "set-custom-option";

    public SetCustomOptionCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        OptionContainer optionContainer = (OptionContainer)this.getContext();
        try {
            String name = this.requiredArgument(0, I18n.bind((String)RelationalCommandsI18n.missingOptionNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)RelationalCommandsI18n.missingOptionNameValue, (Object[])new Object[0]));
            if (optionContainer.isStandardOption(name)) {
                throw new KException(I18n.bind((String)RelationalCommandsI18n.useSetPropertyCommand, (Object[])new Object[]{"set-property"}));
            }
            OptionContainerUtils.setOption((Repository.UnitOfWork)this.getTransaction(), (OptionContainer)optionContainer, (String)name, (String)value);
            result = new CommandResultImpl(I18n.bind((String)RelationalCommandsI18n.setCustomOptionSuccess, (Object[])new Object[]{name}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    public boolean isValidForCurrentContext() {
        return this.getContext() instanceof OptionContainer;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomOptionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomOptionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomOptionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

