/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.komodo.relational.RelationalObject;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.KomodoObjectUtils;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class SetCustomPropertyCommand
extends RelationalShellCommand {
    static final String NAME = "set-custom-property";

    public SetCustomPropertyCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)RelationalCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)RelationalCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            RelationalObject robject = this.get();
            robject.setProperty(this.getTransaction(), name, new Object[]{value});
            result = new CommandResultImpl(I18n.bind((String)RelationalCommandsI18n.setPropertySuccess, (Object[])new Object[]{name}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    public boolean isValidForCurrentContext() {
        return this.getContext() instanceof RelationalObject && !KomodoObjectUtils.isRootChild((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)this.getContext());
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.setCustomPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }
}

