/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import java.util.List;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.model.OptionContainer;
import org.komodo.relational.model.StatementOption;
import org.komodo.relational.model.internal.OptionContainerUtils;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetCustomOptionCommand
extends RelationalShellCommand {
    static final String NAME = "unset-custom-option";

    public UnsetCustomOptionCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        OptionContainer optionContainer = (OptionContainer)this.getContext();
        try {
            String name = this.requiredArgument(0, I18n.bind((String)RelationalCommandsI18n.unsetMissingOptionName, (Object[])new Object[0]));
            if (optionContainer.isStandardOption(name)) {
                throw new KException(I18n.bind((String)RelationalCommandsI18n.useSetPropertyCommand, (Object[])new Object[]{"unset-property"}));
            }
            OptionContainerUtils.removeOption((Repository.UnitOfWork)this.getTransaction(), (OptionContainer)optionContainer, (String)name);
            result = new CommandResultImpl(I18n.bind((String)RelationalCommandsI18n.setCustomOptionSuccess, (Object[])new Object[]{name}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    public boolean isValidForCurrentContext() {
        return this.getContext() instanceof OptionContainer;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomOptionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomOptionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomOptionUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        String last = "";
        if (!StringUtils.isEmpty((String)lastArgument)) {
            last = lastArgument;
        }
        if (this.getArguments().size() == 0) {
            StatementOption[] options;
            if (!(this.getContext() instanceof OptionContainer)) {
                return TabCompletionModifier.NO_AUTOCOMPLETION;
            }
            for (StatementOption option : options = ((OptionContainer)this.getContext()).getCustomOptions(this.getTransaction())) {
                String optionName = option.getName(this.getTransaction());
                if (!optionName.startsWith(last)) continue;
                candidates.add(optionName);
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

