/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands;

import org.komodo.relational.RelationalObject;
import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.KomodoObjectUtils;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class UnsetCustomPropertyCommand
extends RelationalShellCommand {
    static final String NAME = "unset-custom-property";

    public UnsetCustomPropertyCommand(WorkspaceStatus status) {
        super(status, NAME);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)RelationalCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            RelationalObject robject = this.get();
            robject.setProperty(this.getTransaction(), name, (Object[])null);
            result = new CommandResultImpl(I18n.bind((String)RelationalCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    public boolean isValidForCurrentContext() {
        return this.getContext() instanceof RelationalObject && !KomodoObjectUtils.isRootChild((Repository.UnitOfWork)this.getTransaction(), (KomodoObject)this.getContext());
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)RelationalCommandsI18n.unsetCustomPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }
}

