/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.column;

import java.util.List;
import org.komodo.relational.RelationalConstants;
import org.komodo.relational.commands.column.ColumnCommandsI18n;
import org.komodo.relational.commands.column.ColumnShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Column;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetColumnPropertyCommand
extends ColumnShellCommand {
    static final String NAME = "set-property";

    public SetColumnPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Column column = this.getColumn();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "autoIncrement": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setAutoIncremented(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"autoIncrement"});
                    break;
                }
                case "CASE_SENSITIVE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setCaseSensitive(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"CASE_SENSITIVE"});
                    break;
                }
                case "CHAR_OCTET_LENGTH": {
                    try {
                        long octetLength = Long.parseLong(value);
                        column.setCharOctetLength(transaction, octetLength);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"CHAR_OCTET_LENGTH"});
                    }
                    break;
                }
                case "collationName": {
                    column.setCollationName(transaction, value);
                    break;
                }
                case "CURRENCY": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setCurrency(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"CURRENCY"});
                    break;
                }
                case "datatypeName": {
                    column.setDatatypeName(transaction, value);
                    break;
                }
                case "defaultValue": {
                    column.setDefaultValue(transaction, value);
                    break;
                }
                case "ANNOTATION": {
                    column.setDescription(transaction, value);
                    break;
                }
                case "DISTINCT_VALUES": {
                    try {
                        long nValues = Long.parseLong(value);
                        column.setDistinctValues(transaction, nValues);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"DISTINCT_VALUES"});
                    }
                    break;
                }
                case "FIXED_LENGTH": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setFixedLength(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"FIXED_LENGTH"});
                    break;
                }
                case "datatypeLength": {
                    try {
                        long length = Long.parseLong(value);
                        column.setLength(transaction, length);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeLength"});
                    }
                    break;
                }
                case "MAX_VALUE": {
                    column.setMaxValue(transaction, value);
                    break;
                }
                case "MIN_VALUE": {
                    column.setMinValue(transaction, value);
                    break;
                }
                case "NAMEINSOURCE": {
                    column.setNameInSource(transaction, value);
                    break;
                }
                case "NATIVE_TYPE": {
                    column.setNativeType(transaction, value);
                    break;
                }
                case "nullable": {
                    if (RelationalConstants.Nullable.NO_NULLS.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NO_NULLS);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NULLABLE);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE_UNKNOWN.name().equals(value)) {
                        column.setNullable(transaction, RelationalConstants.Nullable.NULLABLE_UNKNOWN);
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidNullablePropertyValue, (Object[])new Object[]{"nullable"});
                    break;
                }
                case "NULL_VALUE_COUNT": {
                    try {
                        long count = Long.parseLong(value);
                        column.setNullValueCount(transaction, count);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"NULL_VALUE_COUNT"});
                    }
                    break;
                }
                case "datatypePrecision": {
                    try {
                        long precision = Long.parseLong(value);
                        column.setPrecision(transaction, precision);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypePrecision"});
                    }
                    break;
                }
                case "RADIX": {
                    try {
                        long radix = Long.parseLong(value);
                        column.setRadix(transaction, radix);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"RADIX"});
                    }
                    break;
                }
                case "datatypeScale": {
                    try {
                        long scale = Long.parseLong(value);
                        column.setScale(transaction, scale);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeScale"});
                    }
                    break;
                }
                case "SEARCHABLE": {
                    if (Column.Searchable.ALL_EXCEPT_LIKE.name().equals(value)) {
                        column.setSearchable(transaction, Column.Searchable.ALL_EXCEPT_LIKE);
                        break;
                    }
                    if (Column.Searchable.LIKE_ONLY.name().equals(value)) {
                        column.setSearchable(transaction, Column.Searchable.LIKE_ONLY);
                        break;
                    }
                    if (Column.Searchable.SEARCHABLE.name().equals(value)) {
                        column.setSearchable(transaction, Column.Searchable.SEARCHABLE);
                        break;
                    }
                    if (Column.Searchable.UNSEARCHABLE.name().equals(value)) {
                        column.setSearchable(transaction, Column.Searchable.UNSEARCHABLE);
                        break;
                    }
                    errorMsg = I18n.bind((String)ColumnCommandsI18n.invalidSearchablePropertyValue, (Object[])new Object[]{"SEARCHABLE"});
                    break;
                }
                case "SELECTABLE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setSelectable(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"SELECTABLE"});
                    break;
                }
                case "SIGNED": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setSigned(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"SIGNED"});
                    break;
                }
                case "UPDATABLE": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        column.setUpdatable(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"UPDATABLE"});
                    break;
                }
                case "UUID": {
                    column.setUuid(transaction, value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Column.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.setColumnPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.setColumnPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.setColumnPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("autoIncrement".equals(theArg) || "CASE_SENSITIVE".equals(theArg) || "CURRENCY".equals(theArg) || "FIXED_LENGTH".equals(theArg) || "SELECTABLE".equals(theArg) || "UPDATABLE".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("nullable".equals(theArg)) {
                candidates.add(RelationalConstants.Nullable.NO_NULLS.name());
                candidates.add(RelationalConstants.Nullable.NULLABLE.name());
                candidates.add(RelationalConstants.Nullable.NULLABLE_UNKNOWN.name());
            } else if ("SEARCHABLE".equals(theArg)) {
                candidates.add(Column.Searchable.ALL_EXCEPT_LIKE.name());
                candidates.add(Column.Searchable.LIKE_ONLY.name());
                candidates.add(Column.Searchable.SEARCHABLE.name());
                candidates.add(Column.Searchable.UNSEARCHABLE.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

