/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.column;

import java.util.List;
import org.komodo.relational.commands.column.ColumnCommandsI18n;
import org.komodo.relational.commands.column.ColumnShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Column;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetColumnPropertyCommand
extends ColumnShellCommand {
    static final String NAME = "unset-property";

    public UnsetColumnPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            Column column = this.getColumn();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "autoIncrement": {
                    column.setAutoIncremented(transaction, false);
                    break;
                }
                case "CASE_SENSITIVE": {
                    column.setCaseSensitive(transaction, false);
                    break;
                }
                case "CHAR_OCTET_LENGTH": {
                    column.setCharOctetLength(transaction, 0L);
                    break;
                }
                case "collationName": {
                    column.setCollationName(transaction, null);
                    break;
                }
                case "CURRENCY": {
                    column.setCurrency(transaction, false);
                    break;
                }
                case "datatypeName": {
                    column.setDatatypeName(transaction, null);
                    break;
                }
                case "defaultValue": {
                    column.setDefaultValue(transaction, null);
                    break;
                }
                case "ANNOTATION": {
                    column.setDescription(transaction, null);
                    break;
                }
                case "DISTINCT_VALUES": {
                    column.setDistinctValues(transaction, -1L);
                    break;
                }
                case "FIXED_LENGTH": {
                    column.setFixedLength(transaction, false);
                    break;
                }
                case "datatypeLength": {
                    column.setLength(transaction, 0L);
                    break;
                }
                case "MAX_VALUE": {
                    column.setMaxValue(transaction, null);
                    break;
                }
                case "MIN_VALUE": {
                    column.setMinValue(transaction, null);
                    break;
                }
                case "NAMEINSOURCE": {
                    column.setNameInSource(transaction, null);
                    break;
                }
                case "NATIVE_TYPE": {
                    column.setNativeType(transaction, null);
                    break;
                }
                case "nullable": {
                    column.setNullable(transaction, null);
                    break;
                }
                case "NULL_VALUE_COUNT": {
                    column.setNullValueCount(transaction, -1L);
                    break;
                }
                case "datatypePrecision": {
                    column.setPrecision(transaction, 0L);
                    break;
                }
                case "RADIX": {
                    column.setRadix(transaction, 0L);
                    break;
                }
                case "datatypeScale": {
                    column.setScale(transaction, 0L);
                    break;
                }
                case "SEARCHABLE": {
                    column.setSearchable(transaction, null);
                    break;
                }
                case "SELECTABLE": {
                    column.setSelectable(transaction, true);
                    break;
                }
                case "SIGNED": {
                    column.setSigned(transaction, false);
                    break;
                }
                case "UPDATABLE": {
                    column.setUpdatable(transaction, true);
                    break;
                }
                case "UUID": {
                    column.setUuid(transaction, null);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Column.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{column.getName(transaction), name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.unsetColumnPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.unsetColumnPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ColumnCommandsI18n.unsetColumnPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

