/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.connection;

import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.RelationalShellCommand;
import org.komodo.relational.connection.Connection;
import org.komodo.shell.api.WorkspaceStatus;

abstract class ConnectionShellCommand
extends RelationalShellCommand {
    protected static final String JNDI_NAME = "jndiName";
    protected static final String DESCRIPTION = "description";
    protected static final String EXT_LOC = "externalLocation";
    protected static final String DRIVER_NAME = "driverName";
    protected static final String CLASS_NAME = "className";
    protected static final String JDBC = "jdbc";
    protected static final List<String> ALL_PROPS = Arrays.asList("description", "externalLocation", "jndiName", "driverName", "className", "jdbc");

    protected ConnectionShellCommand(String name, WorkspaceStatus status) {
        super(status, name);
    }

    protected Connection getConnection() throws Exception {
        assert (this.getContext() instanceof Connection);
        return (Connection)Connection.RESOLVER.resolve(this.getTransaction(), this.getContext());
    }

    public final boolean isValidForCurrentContext() {
        try {
            return Connection.RESOLVER.resolvable(this.getTransaction(), this.getContext());
        }
        catch (Exception ex) {
            return false;
        }
    }
}

