/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.connection;

import java.util.List;
import org.komodo.relational.commands.connection.ConnectionCommandsI18n;
import org.komodo.relational.commands.connection.ConnectionShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.connection.Connection;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetConnectionPropertyCommand
extends ConnectionShellCommand {
    static final String NAME = "unset-property";

    public UnsetConnectionPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            Connection connection = this.getConnection();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            if ("description".equals(name)) {
                connection.setDescription(transaction, null);
            } else if ("externalLocation".equals(name)) {
                connection.setExternalLocation(transaction, null);
            } else if ("jndiName".equals(name)) {
                connection.setJndiName(transaction, null);
            } else if ("driverName".equals(name)) {
                connection.setDriverName(transaction, null);
            } else if ("className".equals(name)) {
                connection.setDriverName(transaction, null);
            } else if ("jdbc".equals(name)) {
                connection.setJdbc(transaction, true);
            } else {
                errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Connection.class.getSimpleName()});
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ConnectionCommandsI18n.unsetConnectionPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ConnectionCommandsI18n.unsetConnectionPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ConnectionCommandsI18n.unsetConnectionPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

