/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddMappedRoleCommand
extends DataRoleShellCommand {
    static final String NAME = "add-mapped-role";

    public AddMappedRoleCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String mappedRoleName = this.requiredArgument(0, I18n.bind((String)DataRoleCommandsI18n.missingMappedRoleName, (Object[])new Object[0]));
            DataRole dataRole = this.getDataRole();
            String[] mappedRoleNames = dataRole.getMappedRoles(this.getTransaction(), new String[]{mappedRoleName});
            if (mappedRoleNames.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{mappedRoleName, "MappedRole"}), null);
            }
            dataRole.addMappedRole(this.getTransaction(), mappedRoleName);
            result = new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.mappedRoleAdded, (Object[])new Object[]{mappedRoleName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addMappedRoleHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addMappedRoleExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addMappedRoleUsage, (Object[])new Object[0]), new Object[0]);
    }
}

