/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddPermissionCommand
extends DataRoleShellCommand {
    static final String NAME = "add-permission";

    public AddPermissionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String permissionName = this.requiredArgument(0, I18n.bind((String)DataRoleCommandsI18n.missingPermissionName, (Object[])new Object[0]));
            DataRole dataRole = this.getDataRole();
            Permission[] permissions = dataRole.getPermissions(this.getTransaction(), new String[]{permissionName});
            if (permissions.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{permissionName, Permission.class.getSimpleName()}), null);
            }
            dataRole.addPermission(this.getTransaction(), permissionName);
            result = new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.permissionAdded, (Object[])new Object[]{permissionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addPermissionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addPermissionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.addPermissionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

