/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteMappedRoleCommand
extends DataRoleShellCommand {
    static final String NAME = "delete-mapped-role";

    public DeleteMappedRoleCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String mappedRoleName = this.requiredArgument(0, I18n.bind((String)DataRoleCommandsI18n.missingMappedRoleName, (Object[])new Object[0]));
            DataRole dataRole = this.getDataRole();
            String[] mappedRoles = dataRole.getMappedRoles(this.getTransaction(), new String[0]);
            if (mappedRoles.length == 0) {
                return new CommandResultImpl(false, I18n.bind((String)DataRoleCommandsI18n.deleteMappedRoleNoRolesError, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), null);
            }
            if (!Arrays.asList(mappedRoles).contains(mappedRoleName)) {
                return new CommandResultImpl(false, I18n.bind((String)DataRoleCommandsI18n.deleteMappedRoleNoMatchingRoleError, (Object[])new Object[]{dataRole.getName(this.getTransaction()), mappedRoleName}), null);
            }
            dataRole.removeMappedRole(this.getTransaction(), mappedRoleName);
            result = new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.mappedRoleDeleted, (Object[])new Object[]{mappedRoleName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deleteMappedRoleHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deleteMappedRoleExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deleteMappedRoleUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        DataRole dataRole = this.getDataRole();
        String[] mappedRoles = dataRole.getMappedRoles(uow, new String[0]);
        ArrayList<String> existingRoleNames = new ArrayList<String>(mappedRoles.length);
        for (String mappedRole : mappedRoles) {
            existingRoleNames.add(mappedRole);
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingRoleNames);
            } else {
                for (String item : existingRoleNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

