/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeletePermissionCommand
extends DataRoleShellCommand {
    static final String NAME = "delete-permission";

    public DeletePermissionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String permissionName = this.requiredArgument(0, I18n.bind((String)DataRoleCommandsI18n.missingPermissionName, (Object[])new Object[0]));
            DataRole dataRole = this.getDataRole();
            dataRole.removePermission(this.getTransaction(), permissionName);
            result = new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.permissionDeleted, (Object[])new Object[]{permissionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deletePermissionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deletePermissionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.deletePermissionUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        DataRole dataRole = this.getDataRole();
        Permission[] permissions = dataRole.getPermissions(uow, new String[0]);
        ArrayList<String> existingPermissionNames = new ArrayList<String>(permissions.length);
        for (Permission permission : permissions) {
            existingPermissionNames.add(permission.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingPermissionNames);
            } else {
                for (String item : existingPermissionNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

