/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import java.util.List;
import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.DataRole;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetDataRolePropertyCommand
extends DataRoleShellCommand {
    static final String NAME = "set-property";

    public SetDataRolePropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            DataRole dataRole = this.getDataRole();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "allowCreateTemporaryTables": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        dataRole.setAllowCreateTempTables(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"allowCreateTemporaryTables"});
                    break;
                }
                case "anyAuthenticated": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        dataRole.setAnyAuthenticated(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"anyAuthenticated"});
                    break;
                }
                case "description": {
                    dataRole.setDescription(transaction, value);
                    break;
                }
                case "grantAll": {
                    if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                        dataRole.setGrantAll(transaction, Boolean.parseBoolean(value));
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"grantAll"});
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, DataRole.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.setDataRolePropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.setDataRolePropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.setDataRolePropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        String theArg;
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1 && ("allowCreateTemporaryTables".equals(theArg = (String)this.getArguments().get(0)) || "anyAuthenticated".equals(theArg) || "grantAll".equals(theArg))) {
            this.updateCandidatesForBooleanProperty(lastArgument, candidates);
        }
        return TabCompletionModifier.AUTO;
    }
}

