/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.vdb.DataRole;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class ShowMappedRolesCommand
extends DataRoleShellCommand {
    static final String NAME = "show-mapped-roles";

    public ShowMappedRolesCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            DataRole dataRole = this.getDataRole();
            String[] roles = dataRole.getMappedRoles(this.getTransaction(), namePatterns);
            if (roles.length == 0) {
                result = hasPatterns ? new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.noMatchingMappedRoles, (Object[])new Object[]{dataRole.getName(this.getTransaction())})) : new CommandResultImpl(I18n.bind((String)DataRoleCommandsI18n.noMappedRoles, (Object[])new Object[]{dataRole.getName(this.getTransaction())}));
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.matchingMappedRolesHeader, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.mappedRolesHeader, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (String role : roles) {
                    this.print(10, role, new Object[0]);
                }
            }
            result = CommandResult.SUCCESS;
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showMappedRolesHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showMappedRolesExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showMappedRolesUsage, (Object[])new Object[0]), new Object[0]);
    }
}

