/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datarole;

import org.komodo.relational.commands.datarole.DataRoleCommandsI18n;
import org.komodo.relational.commands.datarole.DataRoleShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowPermissionsCommand
extends DataRoleShellCommand {
    static final String NAME = "show-permissions";

    public ShowPermissionsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            DataRole dataRole = this.getDataRole();
            Permission[] permissions = dataRole.getPermissions(this.getTransaction(), namePatterns);
            if (permissions.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.noMatchingPermissions, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.noPermissions, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.matchingPermissionsHeader, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)DataRoleCommandsI18n.permissionsHeader, (Object[])new Object[]{dataRole.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Permission permission : permissions) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{permission.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)permission, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showPermissionsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showPermissionsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataRoleCommandsI18n.showPermissionsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

