/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datatyperesultset;

import java.util.List;
import org.komodo.relational.RelationalConstants;
import org.komodo.relational.commands.datatyperesultset.DataTypeResultSetCommandsI18n;
import org.komodo.relational.commands.datatyperesultset.DataTypeResultSetShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.DataTypeResultSet;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.util.KomodoObjectUtils;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetDataTypeResultSetPropertyCommand
extends DataTypeResultSetShellCommand {
    static final String NAME = "set-property";

    public SetDataTypeResultSetPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            DataTypeResultSet rs = this.getDataTypeResultSet();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "datatypeName": {
                    if (DataTypeResultSet.Type.BIGDECIMAL.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BIGDECIMAL);
                    } else if (DataTypeResultSet.Type.BIGINT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BIGINT);
                    } else if (DataTypeResultSet.Type.BIGINTEGER.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BIGINTEGER);
                    } else if (DataTypeResultSet.Type.BLOB.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BLOB);
                    } else if (DataTypeResultSet.Type.BOOLEAN.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BOOLEAN);
                    } else if (DataTypeResultSet.Type.BYTE.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.BYTE);
                    } else if (DataTypeResultSet.Type.CHAR.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.CHAR);
                    } else if (DataTypeResultSet.Type.CLOB.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.CLOB);
                    } else if (DataTypeResultSet.Type.DATE.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.DATE);
                    } else if (DataTypeResultSet.Type.DECIMAL.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.DECIMAL);
                    } else if (DataTypeResultSet.Type.DEFAULT_VALUE.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.DEFAULT_VALUE);
                    } else if (DataTypeResultSet.Type.DOUBLE.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.DOUBLE);
                    } else if (DataTypeResultSet.Type.FLOAT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.FLOAT);
                    } else if (DataTypeResultSet.Type.INTEGER.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.INTEGER);
                    } else if (DataTypeResultSet.Type.LONG.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.LONG);
                    } else if (DataTypeResultSet.Type.OBJECT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.OBJECT);
                    } else if (DataTypeResultSet.Type.REAL.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.REAL);
                    } else if (DataTypeResultSet.Type.SHORT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.SHORT);
                    } else if (DataTypeResultSet.Type.SMALLINT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.SMALLINT);
                    } else if (DataTypeResultSet.Type.STRING.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.STRING);
                    } else if (DataTypeResultSet.Type.TIME.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.TIME);
                    } else if (DataTypeResultSet.Type.TIMESTAMP.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.TIMESTAMP);
                    } else if (DataTypeResultSet.Type.TINYINT.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.TINYINT);
                    } else if (DataTypeResultSet.Type.VARBINARY.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.VARBINARY);
                    } else if (DataTypeResultSet.Type.VARCHAR.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.VARCHAR);
                    } else if (DataTypeResultSet.Type.XML.name().equals(value)) {
                        rs.setType(transaction, DataTypeResultSet.Type.XML);
                    } else {
                        errorMsg = I18n.bind((String)DataTypeResultSetCommandsI18n.invalidDataTypeName, (Object[])new Object[]{"datatypeName"});
                    }
                    if (!StringUtils.isBlank(errorMsg)) break;
                    String arrayArg = this.optionalArgument(2, Boolean.FALSE.toString());
                    if (KomodoObjectUtils.TRUE_STRING.equals(arrayArg) || KomodoObjectUtils.FALSE_STRING.equals(arrayArg)) {
                        rs.setArray(transaction, Boolean.parseBoolean(arrayArg));
                        break;
                    }
                    errorMsg = I18n.bind((String)DataTypeResultSetCommandsI18n.invalidDataTypeArrayIndicator, (Object[])new Object[0]);
                    break;
                }
                case "ANNOTATION": {
                    rs.setDescription(transaction, value);
                    break;
                }
                case "datatypeLength": {
                    try {
                        long length = Long.parseLong(value);
                        rs.setLength(transaction, length);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeLength"});
                    }
                    break;
                }
                case "NAMEINSOURCE": {
                    rs.setNameInSource(transaction, value);
                    break;
                }
                case "nullable": {
                    if (RelationalConstants.Nullable.NO_NULLS.name().equals(value)) {
                        rs.setNullable(transaction, RelationalConstants.Nullable.NO_NULLS);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE.name().equals(value)) {
                        rs.setNullable(transaction, RelationalConstants.Nullable.NULLABLE);
                        break;
                    }
                    if (RelationalConstants.Nullable.NULLABLE_UNKNOWN.name().equals(value)) {
                        rs.setNullable(transaction, RelationalConstants.Nullable.NULLABLE_UNKNOWN);
                        break;
                    }
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidNullablePropertyValue, (Object[])new Object[]{"nullable"});
                    break;
                }
                case "datatypePrecision": {
                    try {
                        long precision = Long.parseLong(value);
                        rs.setPrecision(transaction, precision);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypePrecision"});
                    }
                    break;
                }
                case "datatypeScale": {
                    try {
                        long scale = Long.parseLong(value);
                        rs.setScale(transaction, scale);
                    }
                    catch (NumberFormatException e) {
                        errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidIntegerPropertyValue, (Object[])new Object[]{"datatypeScale"});
                    }
                    break;
                }
                case "UUID": {
                    rs.setUuid(transaction, value);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, DataTypeResultSet.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 3;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.setDataTypeResultSetPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.setDataTypeResultSetPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.setDataTypeResultSetPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() >= 1 && "datatypeName".equals(args.get(0))) {
            if (args.size() == 1) {
                for (DataTypeResultSet.Type type : DataTypeResultSet.Type.values()) {
                    if (!StringUtils.isBlank((String)lastArgument) && !type.name().startsWith(lastArgument)) continue;
                    candidates.add(type.name());
                }
            } else if (args.size() == 2) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

