/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.datatyperesultset;

import java.util.List;
import org.komodo.relational.commands.datatyperesultset.DataTypeResultSetCommandsI18n;
import org.komodo.relational.commands.datatyperesultset.DataTypeResultSetShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.DataTypeResultSet;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class UnsetDataTypeResultSetPropertyCommand
extends DataTypeResultSetShellCommand {
    static final String NAME = "unset-property";

    public UnsetDataTypeResultSetPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.unsetMissingPropertyName, (Object[])new Object[0]));
            DataTypeResultSet rs = this.getDataTypeResultSet();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            switch (name) {
                case "datatypeName": {
                    rs.setType(transaction, null);
                    break;
                }
                case "ANNOTATION": {
                    rs.setDescription(transaction, null);
                    break;
                }
                case "datatypeLength": {
                    rs.setLength(transaction, 0L);
                    break;
                }
                case "NAMEINSOURCE": {
                    rs.setNameInSource(transaction, null);
                    break;
                }
                case "nullable": {
                    rs.setNullable(transaction, null);
                    break;
                }
                case "datatypePrecision": {
                    rs.setPrecision(transaction, 0L);
                    break;
                }
                case "datatypeScale": {
                    rs.setScale(transaction, 0L);
                    break;
                }
                case "UUID": {
                    rs.setUuid(transaction, null);
                    break;
                }
                default: {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, DataTypeResultSet.class.getSimpleName()});
                }
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.unsetPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.unsetDataTypeResultSetPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.unsetDataTypeResultSetPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)DataTypeResultSetCommandsI18n.unsetDataTypeResultSetPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

