/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.foreignkey;

import java.util.List;
import org.komodo.relational.commands.FindCommand;
import org.komodo.relational.commands.foreignkey.ForeignKeyCommandsI18n;
import org.komodo.relational.commands.foreignkey.ForeignKeyShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ForeignKey;
import org.komodo.relational.model.Table;
import org.komodo.repository.ObjectImpl;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class AddReferenceColumnCommand
extends ForeignKeyShellCommand {
    static final String NAME = "add-ref-column";

    public AddReferenceColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnPath = this.requiredArgument(0, I18n.bind((String)ForeignKeyCommandsI18n.missingColumnPathForAdd, (Object[])new Object[0]));
            Column column = null;
            String repoPath = this.getWorkspaceStatus().getCurrentContextLabelProvider().getPath(this.getTransaction(), columnPath);
            if (StringUtils.isBlank((String)repoPath)) {
                repoPath = columnPath;
            }
            ObjectImpl possible = new ObjectImpl(this.getRepository(), repoPath, 0);
            try {
                if (Column.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)possible)) {
                    column = (Column)Column.RESOLVER.resolve(this.getTransaction(), (KomodoObject)possible);
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)ForeignKeyCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPath}), null);
                }
            }
            catch (Exception e) {
                result = new CommandResultImpl(false, I18n.bind((String)ForeignKeyCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPath}), e);
            }
            if (column != null) {
                ForeignKey foreignKey = this.getForeignKey();
                Table parentTable = foreignKey.getParent(this.getTransaction());
                if (parentTable.equals(column.getParent(this.getTransaction()))) {
                    result = new CommandResultImpl(false, I18n.bind((String)ForeignKeyCommandsI18n.invalidColumn, (Object[])new Object[]{this.getWorkspaceStatus().getCurrentContextLabelProvider().getDisplayPath(this.getTransaction(), column.getAbsolutePath(), null), foreignKey.getName(this.getTransaction())}), null);
                } else {
                    foreignKey.addReferencesColumn(this.getTransaction(), column);
                    result = new CommandResultImpl(I18n.bind((String)ForeignKeyCommandsI18n.columnRefAdded, (Object[])new Object[]{columnPath, this.getContext().getAbsolutePath()}));
                }
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.addReferenceColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.addReferenceColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.addReferenceColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        if (this.getArguments().isEmpty()) {
            Repository.UnitOfWork uow = this.getTransaction();
            String[] allDisplayPaths = FindCommand.query(this.getWorkspaceStatus(), KomodoType.COLUMN, null, null);
            if (allDisplayPaths.length == 0) {
                return TabCompletionModifier.AUTO;
            }
            Table parent = this.getForeignKey().getTable(uow);
            String parentPath = parent.getAbsolutePath();
            String parentDisplayPath = this.getWorkspaceStatus().getCurrentContextLabelProvider().getDisplayPath(this.getTransaction(), parentPath, null);
            for (String displayPath : allDisplayPaths) {
                if (displayPath.startsWith(parentDisplayPath) || !StringUtils.isBlank((String)lastArgument) && !displayPath.startsWith(lastArgument)) continue;
                candidates.add(displayPath);
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

