/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.foreignkey;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.komodo.relational.commands.foreignkey.ForeignKeyCommandsI18n;
import org.komodo.relational.commands.foreignkey.ForeignKeyShellCommand;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ForeignKey;
import org.komodo.repository.ObjectImpl;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class DeleteReferenceColumnCommand
extends ForeignKeyShellCommand {
    static final String NAME = "delete-ref-column";

    public DeleteReferenceColumnCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String columnPathArg = this.requiredArgument(0, I18n.bind((String)ForeignKeyCommandsI18n.missingColumnPathForDelete, (Object[])new Object[0]));
            Column column = null;
            String repoPath = this.getWorkspaceStatus().getCurrentContextLabelProvider().getPath(this.getTransaction(), columnPathArg);
            if (StringUtils.isBlank((String)repoPath)) {
                repoPath = columnPathArg;
            }
            ObjectImpl possible = new ObjectImpl(this.getRepository(), repoPath, 0);
            try {
                if (Column.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)possible)) {
                    column = (Column)Column.RESOLVER.resolve(this.getTransaction(), (KomodoObject)possible);
                } else {
                    result = new CommandResultImpl(false, I18n.bind((String)ForeignKeyCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPathArg}), null);
                }
            }
            catch (Exception e) {
                result = new CommandResultImpl(false, I18n.bind((String)ForeignKeyCommandsI18n.invalidColumnPath, (Object[])new Object[]{columnPathArg}), e);
            }
            if (column != null) {
                ForeignKey foreignKey = this.getForeignKey();
                foreignKey.removeReferencesColumn(this.getTransaction(), column);
                result = new CommandResultImpl(I18n.bind((String)ForeignKeyCommandsI18n.columnRemoved, (Object[])new Object[]{columnPathArg, this.getContext().getAbsolutePath()}));
            }
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.deleteReferenceColumnHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.deleteReferenceColumnExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ForeignKeyCommandsI18n.deleteReferenceColumnUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        if (this.getArguments().isEmpty()) {
            ForeignKey foreignKey = this.getForeignKey();
            Column[] refCols = foreignKey.getReferencesColumns(this.getTransaction());
            if (refCols.length == 0) {
                return TabCompletionModifier.AUTO;
            }
            boolean noLastArg = StringUtils.isBlank((String)lastArgument);
            for (Column column : refCols) {
                String displayPath = this.getWorkspaceStatus().getCurrentContextLabelProvider().getDisplayPath(this.getTransaction(), (KomodoObject)column, null);
                String absolutePath = column.getAbsolutePath();
                if (!noLastArg && !displayPath.startsWith(lastArgument) && !absolutePath.startsWith(lastArgument)) continue;
                candidates.add(displayPath);
            }
            Collections.sort(candidates, new Comparator<CharSequence>(){

                @Override
                public int compare(CharSequence thisPath, CharSequence thatPath) {
                    return thisPath.toString().compareTo(thatPath.toString());
                }
            });
        }
        return TabCompletionModifier.AUTO;
    }
}

