/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddPushdownFunctionCommand
extends ModelShellCommand {
    static final String NAME = "add-pushdown-function";

    public AddPushdownFunctionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String pushdownFunctionName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingPushdownFunctionName, (Object[])new Object[0]));
            Model model = this.getModel();
            Function[] functions = model.getFunctions(this.getTransaction(), new String[]{pushdownFunctionName});
            if (functions.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{pushdownFunctionName, Function.class.getSimpleName()}), null);
            }
            model.addPushdownFunction(this.getTransaction(), pushdownFunctionName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.pushdownFunctionAdded, (Object[])new Object[]{pushdownFunctionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addPushdownFunctionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addPushdownFunctionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addPushdownFunctionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

