/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddSourceCommand
extends ModelShellCommand {
    static final String NAME = "add-source";

    public AddSourceCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String sourceName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingSourceName, (Object[])new Object[0]));
            Model model = this.getModel();
            ModelSource[] sources = model.getSources(this.getTransaction(), new String[]{sourceName});
            if (sources.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{sourceName, ModelSource.class.getSimpleName()}), null);
            }
            model.addSource(this.getTransaction(), sourceName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.sourceAdded, (Object[])new Object[]{sourceName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addSourceHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addSourceExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addSourceUsage, (Object[])new Object[0]), new Object[0]);
    }
}

