/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddStoredProcedureCommand
extends ModelShellCommand {
    static final String NAME = "add-stored-procedure";

    public AddStoredProcedureCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String procName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingStoredProcedureName, (Object[])new Object[0]));
            Model model = this.getModel();
            Procedure[] procs = model.getProcedures(this.getTransaction(), new String[]{procName});
            if (procs.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{procName, Procedure.class.getSimpleName()}), null);
            }
            model.addStoredProcedure(this.getTransaction(), procName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.storedProcedureAdded, (Object[])new Object[]{procName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addStoredProcedureHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addStoredProcedureExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addStoredProcedureUsage, (Object[])new Object[0]), new Object[0]);
    }
}

