/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddTableCommand
extends ModelShellCommand {
    static final String NAME = "add-table";

    public AddTableCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String tableName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingTableName, (Object[])new Object[0]));
            Model model = this.getModel();
            Table[] tables = model.getTables(this.getTransaction(), new String[]{tableName});
            if (tables.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{tableName, Table.class.getSimpleName()}), null);
            }
            model.addTable(this.getTransaction(), tableName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.tableAdded, (Object[])new Object[]{tableName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addTableHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addTableExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addTableUsage, (Object[])new Object[0]), new Object[0]);
    }
}

