/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddUserDefinedFunctionCommand
extends ModelShellCommand {
    static final String NAME = "add-user-defined-function";

    public AddUserDefinedFunctionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String udfName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingUserDefinedFunctionName, (Object[])new Object[0]));
            Model model = this.getModel();
            Function[] functions = model.getFunctions(this.getTransaction(), new String[]{udfName});
            if (functions.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{udfName, Function.class.getSimpleName()}), null);
            }
            model.addUserDefinedFunction(this.getTransaction(), udfName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.userDefinedFunctionAdded, (Object[])new Object[]{udfName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addUserDefinedFunctionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addUserDefinedFunctionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addUserDefinedFunctionUsage, (Object[])new Object[0]), new Object[0]);
    }
}

