/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.RelationalCommandsI18n;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.View;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.utils.i18n.I18n;

public final class AddViewCommand
extends ModelShellCommand {
    static final String NAME = "add-view";

    public AddViewCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String viewName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingViewName, (Object[])new Object[0]));
            Model model = this.getModel();
            View[] views = model.getViews(this.getTransaction(), new String[]{viewName});
            if (views.length > 0) {
                return new CommandResultImpl(false, I18n.bind((String)RelationalCommandsI18n.cannotAddChildAlreadyExistsError, (Object[])new Object[]{viewName, View.class.getSimpleName()}), null);
            }
            model.addView(this.getTransaction(), viewName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.viewAdded, (Object[])new Object[]{viewName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addViewHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addViewExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.addViewUsage, (Object[])new Object[0]), new Object[0]);
    }
}

