/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteUserDefinedFunctionCommand
extends ModelShellCommand {
    static final String NAME = "delete-user-defined-function";

    public DeleteUserDefinedFunctionCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String functionName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingUserDefinedFunctionName, (Object[])new Object[0]));
            Model model = this.getModel();
            model.removeFunction(this.getTransaction(), functionName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.userDefinedFunctionDeleted, (Object[])new Object[]{functionName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteUserDefinedFunctionHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteUserDefinedFunctionExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteUserDefinedFunctionUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Model model = this.getModel();
        Function[] functions = model.getFunctions(uow, new String[0]);
        ArrayList<String> existingFunctionNames = new ArrayList<String>(functions.length);
        for (Function function : functions) {
            existingFunctionNames.add(function.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingFunctionNames);
            } else {
                for (String item : existingFunctionNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

