/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import java.util.List;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.View;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class DeleteViewCommand
extends ModelShellCommand {
    static final String NAME = "delete-view";

    public DeleteViewCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String viewName = this.requiredArgument(0, I18n.bind((String)ModelCommandsI18n.missingViewName, (Object[])new Object[0]));
            Model model = this.getModel();
            model.removeView(this.getTransaction(), viewName);
            result = new CommandResultImpl(I18n.bind((String)ModelCommandsI18n.viewDeleted, (Object[])new Object[]{viewName}));
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteViewHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteViewExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.deleteViewUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        Repository.UnitOfWork uow = this.getTransaction();
        Model model = this.getModel();
        View[] views = model.getViews(uow, new String[0]);
        ArrayList<String> existingViewNames = new ArrayList<String>(views.length);
        for (View view : views) {
            existingViewNames.add(view.getName(uow));
        }
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(existingViewNames);
            } else {
                for (String item : existingViewNames) {
                    if (!item.startsWith(lastArgument)) continue;
                    candidates.add(item);
                }
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

