/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.CreateSchemaCommand;
import org.komodo.relational.commands.workspace.DeleteSchemaCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.importer.ddl.DdlImporter;
import org.komodo.relational.model.Schema;
import org.komodo.repository.SynchronousCallback;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.ShellI18n;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.shell.commands.CdCommand;
import org.komodo.shell.commands.RenameCommand;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.i18n.I18n;

public final class ImportCommand
extends ModelShellCommand {
    static final String NAME = "import-ddl";
    private static final String TEMP_IMPORT_CONTEXT = "TempImportContext";

    public ImportCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String validationResult;
            String fileName = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingInputFileName, (Object[])new Object[0]));
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + "ddl";
            }
            if (!"OK".equals(validationResult = this.validateReadableFileArg(fileName))) {
                return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName, validationResult}), null);
            }
            File ddlFile = new File(fileName);
            ImportOptions importOptions = new ImportOptions();
            ImportMessages importMessages = new ImportMessages();
            KomodoObject tempSchema = this.createSchema(TEMP_IMPORT_CONTEXT);
            if (tempSchema == null) {
                return new CommandResultImpl(false, I18n.bind((String)ModelCommandsI18n.errorCreatingTempNode, (Object[])new Object[]{TEMP_IMPORT_CONTEXT}), null);
            }
            WorkspaceStatus wsStatus = this.getWorkspaceStatus();
            this.importDdl(this.getTransaction(), ddlFile, tempSchema, importOptions, importMessages);
            if (!importMessages.hasError()) {
                this.print(5, I18n.bind((String)ModelCommandsI18n.ddlImportInProgressMsg, (Object[])new Object[]{ddlFile}), new Object[0]);
                this.commitImport(ImportCommand.class.getSimpleName(), importMessages);
                if (!importMessages.hasError()) {
                    KomodoObject[] children;
                    for (KomodoObject child : children = tempSchema.getChildren(this.getTransaction(), new String[0])) {
                        RenameCommand renameCommand = new RenameCommand(this.getWorkspaceStatus());
                        String oldFullName = wsStatus.getDisplayPath(child, null);
                        String contextName = wsStatus.getDisplayPath(this.getContext(), null);
                        renameCommand.setArguments(new Arguments(oldFullName + " " + contextName + "/" + child.getName(this.getTransaction())));
                        renameCommand.execute();
                    }
                    this.deleteSchema(wsStatus.getDisplayPath(tempSchema, null));
                    return new CommandResultImpl(true, I18n.bind((String)ModelCommandsI18n.ddlImportSuccessMsg, (Object[])new Object[]{fileName}), null);
                }
                this.print(5, I18n.bind((String)ModelCommandsI18n.importFailedMsg, (Object[])new Object[]{fileName}), new Object[0]);
                this.print(5, importMessages.errorMessagesToString(), new Object[0]);
                this.deleteSchema(wsStatus.getDisplayPath(tempSchema, null));
            } else {
                this.print(5, I18n.bind((String)ModelCommandsI18n.importFailedMsg, (Object[])new Object[]{fileName}), new Object[0]);
                this.print(5, importMessages.errorMessagesToString(), new Object[0]);
                this.deleteSchema(wsStatus.getDisplayPath(tempSchema, null));
            }
            return new CommandResultImpl(false, I18n.bind((String)WorkspaceCommandsI18n.inputFileError, (Object[])new Object[]{fileName}), null);
        }
        catch (Exception e) {
            return new CommandResultImpl(false, I18n.bind((String)ShellI18n.commandFailure, (Object[])new Object[]{NAME}), e);
        }
    }

    private void importDdl(Repository.UnitOfWork uow, File ddlFile, KomodoObject parentObj, ImportOptions importOptions, ImportMessages importMessages) {
        Repository repository = null;
        try {
            repository = parentObj.getRepository();
        }
        catch (Exception ex) {
            importMessages.addErrorMessage(ex.getLocalizedMessage());
            return;
        }
        DdlImporter importer = new DdlImporter(repository);
        importer.importDdl(uow, ddlFile, parentObj, importOptions, importMessages);
    }

    private void commitImport(String source, ImportMessages importMessages) throws Exception {
        boolean success;
        Repository.UnitOfWork trans = this.getTransaction();
        String txName = trans.getName();
        trans.commit();
        Repository.UnitOfWorkListener uowListener = trans.getCallback();
        SynchronousCallback callback = null;
        if (uowListener != null && uowListener instanceof SynchronousCallback) {
            callback = (SynchronousCallback)uowListener;
        }
        if (success = callback.await(3L, TimeUnit.MINUTES)) {
            if (callback.hasError()) {
                importMessages.addErrorMessage(callback.error());
                return;
            }
            KException error = trans.getError();
            Repository.UnitOfWork.State txState = trans.getState();
            if (error != null || !Repository.UnitOfWork.State.COMMITTED.equals((Object)txState)) {
                throw new KException(I18n.bind((String)ShellI18n.transactionCommitError, (Object[])new Object[]{txName}), (Throwable)error);
            }
        } else {
            throw new KException(I18n.bind((String)ShellI18n.transactionTimeout, (Object[])new Object[]{txName}));
        }
    }

    private KomodoObject createSchema(String schemaName) {
        Schema resultSchema = null;
        try {
            KomodoObject origContext = this.getContext();
            CdCommand cdCommand = new CdCommand(this.getWorkspaceStatus());
            cdCommand.setArguments(new Arguments("/"));
            CommandResult result = cdCommand.execute();
            if (!result.isOk()) {
                return resultSchema;
            }
            CreateSchemaCommand createCommand = new CreateSchemaCommand(this.getWorkspaceStatus());
            createCommand.setArguments(new Arguments(schemaName));
            result = createCommand.execute();
            if (result.isOk()) {
                Schema[] schemas;
                for (Schema schema : schemas = this.getWorkspaceManager(this.getTransaction()).findSchemas(this.getTransaction())) {
                    if (!schema.getName(this.getTransaction()).equals(schemaName)) continue;
                    resultSchema = schema;
                    break;
                }
            }
            String path = this.getWorkspaceStatus().getDisplayPath(origContext, null);
            cdCommand.setArguments(new Arguments(path));
            cdCommand.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultSchema;
    }

    private CommandResult deleteSchema(String schemaName) {
        DeleteSchemaCommand deleteCommand = new DeleteSchemaCommand(this.getWorkspaceStatus());
        try {
            deleteCommand.setArguments(new Arguments(schemaName));
            deleteCommand.execute();
        }
        catch (Exception e) {
            this.print(5, I18n.bind((String)ModelCommandsI18n.deleteTempContextFailedMsg, (Object[])new Object[]{schemaName}), new Object[0]);
        }
        CommandResult result = null;
        return result;
    }

    protected int getMaxArgCount() {
        return 1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.importHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.importExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.importUsage, (Object[])new Object[0]), new Object[0]);
    }
}

