/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.List;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.Arguments;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.TabCompletionModifier;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;
import org.komodo.utils.i18n.I18n;

public final class SetModelPropertyCommand
extends ModelShellCommand {
    static final String NAME = "set-property";

    public SetModelPropertyCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        CommandResultImpl result = null;
        try {
            String name = this.requiredArgument(0, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            String value = this.requiredArgument(1, I18n.bind((String)WorkspaceCommandsI18n.missingPropertyNameValue, (Object[])new Object[0]));
            Model model = this.getModel();
            Repository.UnitOfWork transaction = this.getTransaction();
            String errorMsg = null;
            if ("description".equals(name)) {
                model.setDescription(transaction, value);
            } else if ("metadataType".equals(name)) {
                model.setMetadataType(transaction, value);
            } else if ("modelType".equals(name)) {
                if (Model.Type.PHYSICAL.name().equalsIgnoreCase(value)) {
                    model.setModelType(transaction, Model.Type.PHYSICAL);
                } else if (Model.Type.VIRTUAL.name().equalsIgnoreCase(value)) {
                    model.setModelType(transaction, Model.Type.VIRTUAL);
                } else {
                    errorMsg = I18n.bind((String)ModelCommandsI18n.invalidModelTypePropertyValue, (Object[])new Object[]{value});
                }
            } else if ("visible".equals(name)) {
                if (Boolean.TRUE.toString().equals(value) || Boolean.FALSE.toString().equals(value)) {
                    model.setVisible(transaction, Boolean.parseBoolean(value));
                } else {
                    errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidBooleanPropertyValue, (Object[])new Object[]{"visible"});
                }
            } else {
                errorMsg = I18n.bind((String)WorkspaceCommandsI18n.invalidPropertyName, (Object[])new Object[]{name, Model.class.getSimpleName()});
            }
            result = StringUtils.isBlank(errorMsg) ? new CommandResultImpl(I18n.bind((String)WorkspaceCommandsI18n.setPropertySuccess, (Object[])new Object[]{name})) : new CommandResultImpl(false, errorMsg, null);
        }
        catch (Exception e) {
            result = new CommandResultImpl(e);
        }
        return result;
    }

    protected int getMaxArgCount() {
        return 2;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.setModelPropertyHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.setModelPropertyExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.setModelPropertyUsage, (Object[])new Object[0]), new Object[0]);
    }

    public TabCompletionModifier tabCompletion(String lastArgument, List<CharSequence> candidates) throws Exception {
        Arguments args = this.getArguments();
        if (args.isEmpty()) {
            if (lastArgument == null) {
                candidates.addAll(ALL_PROPS);
            } else {
                for (String item : ALL_PROPS) {
                    if (!item.toUpperCase().startsWith(lastArgument.toUpperCase())) continue;
                    candidates.add(item);
                }
            }
        }
        if (args.size() == 1) {
            String theArg = (String)this.getArguments().get(0);
            if ("visible".equals(theArg)) {
                this.updateCandidatesForBooleanProperty(lastArgument, candidates);
            } else if ("modelType".equals(theArg)) {
                candidates.add(Model.Type.PHYSICAL.name());
                candidates.add(Model.Type.VIRTUAL.name());
            }
        }
        return TabCompletionModifier.AUTO;
    }
}

