/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Function;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.PushdownFunction;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowPushdownFunctionsCommand
extends ModelShellCommand {
    static final String NAME = "show-pushdown-functions";

    public ShowPushdownFunctionsCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Model model = this.getModel();
            Function[] functions = model.getFunctions(this.getTransaction(), namePatterns);
            if (functions.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingPushdownFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noPushdownFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                ArrayList<Function> pushdowns = new ArrayList<Function>(functions.length);
                for (Function function : functions) {
                    if (!PushdownFunction.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)function)) continue;
                    pushdowns.add(function);
                }
                if (pushdowns.isEmpty()) {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingPushdownFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noPushdownFunctions, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                } else {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.matchedPushdownFunctionsHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.pushdownsHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                    int indent = 10;
                    for (Function function : pushdowns) {
                        this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{function.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)function, null)}), new Object[0]);
                    }
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showPushdownFunctionsHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showPushdownFunctionsExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showPushdownFunctionsUsage, (Object[])new Object[0]), new Object[0]);
    }
}

