/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import java.util.ArrayList;
import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Procedure;
import org.komodo.relational.model.StoredProcedure;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowStoredProceduresCommand
extends ModelShellCommand {
    static final String NAME = "show-stored-procedures";

    public ShowStoredProceduresCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Model model = this.getModel();
            Procedure[] procedures = model.getProcedures(this.getTransaction(), namePatterns);
            if (procedures.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingStoredProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noStoredProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                ArrayList<Procedure> storedProcedures = new ArrayList<Procedure>(procedures.length);
                for (Procedure procedure : procedures) {
                    if (!StoredProcedure.RESOLVER.resolvable(this.getTransaction(), (KomodoObject)procedure)) continue;
                    storedProcedures.add(procedure);
                }
                if (storedProcedures.isEmpty()) {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingStoredProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.noStoredProcedures, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                } else {
                    if (hasPatterns) {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.matchedStoredProceduresHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    } else {
                        this.print(5, I18n.bind((String)ModelCommandsI18n.storedProceduresHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                    }
                    int indent = 10;
                    for (Procedure storedProc : storedProcedures) {
                        this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{storedProc.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)storedProc, null)}), new Object[0]);
                    }
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showStoredProceduresHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showStoredProceduresExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showStoredProceduresUsage, (Object[])new Object[0]), new Object[0]);
    }
}

