/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.relational.commands.model;

import org.komodo.relational.commands.model.ModelCommandsI18n;
import org.komodo.relational.commands.model.ModelShellCommand;
import org.komodo.relational.commands.workspace.WorkspaceCommandsI18n;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.shell.CommandResultImpl;
import org.komodo.shell.api.CommandResult;
import org.komodo.shell.api.WorkspaceStatus;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.utils.i18n.I18n;

public final class ShowTablesCommand
extends ModelShellCommand {
    static final String NAME = "show-tables";

    public ShowTablesCommand(WorkspaceStatus status) {
        super(NAME, status);
    }

    protected CommandResult doExecute() {
        try {
            String[] namePatterns = this.processOptionalArguments(0);
            boolean hasPatterns = namePatterns.length != 0;
            Model model = this.getModel();
            Table[] tables = model.getTables(this.getTransaction(), namePatterns);
            if (tables.length == 0) {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noMatchingTables, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.noTables, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
            } else {
                if (hasPatterns) {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.matchedTablesHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                } else {
                    this.print(5, I18n.bind((String)ModelCommandsI18n.tablesHeader, (Object[])new Object[]{model.getName(this.getTransaction())}), new Object[0]);
                }
                int indent = 10;
                for (Table table : tables) {
                    this.print(10, I18n.bind((String)WorkspaceCommandsI18n.printRelationalObject, (Object[])new Object[]{table.getName(this.getTransaction()), this.getWorkspaceStatus().getTypeDisplay((KomodoObject)table, null)}), new Object[0]);
                }
            }
            return CommandResult.SUCCESS;
        }
        catch (Exception e) {
            return new CommandResultImpl(e);
        }
    }

    protected int getMaxArgCount() {
        return -1;
    }

    protected void printHelpDescription(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showTablesHelp, (Object[])new Object[]{this.getName()}), new Object[0]);
    }

    protected void printHelpExamples(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showTablesExamples, (Object[])new Object[0]), new Object[0]);
    }

    protected void printHelpUsage(int indent) {
        this.print(indent, I18n.bind((String)ModelCommandsI18n.showTablesUsage, (Object[])new Object[0]), new Object[0]);
    }
}

